// config: norepeat

#include "GetObjects.js"

function DoExtend()
{
	var objectpicker = moi.ui.createObjectPicker();
	objectpicker.allowCurves();
	
	if ( !GetObjects( objectpicker ) )
		return;

	var factory = moi.command.createFactory( 'extend' );
		
	var objects = objectpicker.objects;
	factory.setInput( 0, objects );
	
	moi.ui.beginUIUpdate();
	moi.ui.hideUI( 'SelectObjectsPrompt' );
	
	// If there are only 2 curves, then show the prompt with the "mutual extension" text.
	moi.ui.showUI( (objects.length == 2 && objects.numCurves == 2) ? 'SelectBoundariesOrMutualPrompt' : 'SelectBoundariesPrompt' );
	moi.ui.endUIUpdate();
	
	objectpicker.resetAllow();
	if ( !GetObjects( objectpicker, true ) )
		return;
		
	factory.setInput( 1, objectpicker.objects );
	
	factory.commit();
}

DoExtend();
